:-module(helperFunctions,[intersectLists/3,filterR/3]).

:- use_module(library(lists)).
 
intersectLists([],_,[]).
intersectLists([H|T],L,[H|Temp]) :- member(H,L), intersectLists(T,L,Temp).
intersectLists([H|T],L,Temp) :- \+ member(H,L), intersectLists(T,L,Temp).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%filters the RHS of a rule to remove things that are in the set 'Asm' ... not assumptions but defense set
filterR([],_,[]). 
filterR([R|Rs],Asm,Temp) :- member(R,Asm), filterR(Rs,Asm,Temp).
filterR([R|Rs],Asm,[R|Temp]) :- \+ member(R,Asm), filterR(Rs,Asm,Temp).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
